// IOTest.cpp : implementation file
//

#include "stdafx.h"
#include "DEMO.h"
#include "IOTest.h"
#include "CtrlCard.h"
#include "adt8840.h"

extern  CCtrlCard	g_CtrlCard;
extern devnum;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TESTTIMER 2001                 //IO Detection Timer
/////////////////////////////////////////////////////////////////////////////
// CIOTest dialog


CIOTest::CIOTest(CWnd* pParent /*=NULL*/)
	: CDialog(CIOTest::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIOTest)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CIOTest::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIOTest)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CIOTest, CDialog)
	//{{AFX_MSG_MAP(CIOTest)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_OUT_ALLOPEN, OnOutAllopen)
	ON_BN_CLICKED(IDC_OUT_ALLCLOSE, OnOutAllclose)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_OUT0, OnOut0)
	ON_BN_CLICKED(IDC_OUT1, OnOut1)
	ON_BN_CLICKED(IDC_OUT2, OnOut2)
	ON_BN_CLICKED(IDC_OUT3, OnOut3)
	ON_BN_CLICKED(IDC_OUT4, OnOut4)
	ON_BN_CLICKED(IDC_OUT5, OnOut5)
	ON_BN_CLICKED(IDC_OUT6, OnOut6)
	ON_BN_CLICKED(IDC_OUT7, OnOut7)
	ON_BN_CLICKED(IDC_OUT8, OnOut8)
	ON_BN_CLICKED(IDC_OUT9, OnOut9)
	ON_BN_CLICKED(IDC_OUT10, OnOut10)
	ON_BN_CLICKED(IDC_OUT11, OnOut11)
	ON_BN_CLICKED(IDC_OUT12, OnOut12)
	ON_BN_CLICKED(IDC_OUT13, OnOut13)
	ON_BN_CLICKED(IDC_OUT14, OnOut14)
	ON_BN_CLICKED(IDC_OUT15, OnOut15)
	ON_BN_CLICKED(IDC_OUT16, OnOut16)
	ON_BN_CLICKED(IDC_OUT17, OnOut17)
	ON_BN_CLICKED(IDC_OUT18, OnOut18)
	ON_BN_CLICKED(IDC_OUT19, OnOut19)
	ON_BN_CLICKED(IDC_OUT20, OnOut20)
	ON_BN_CLICKED(IDC_OUT21, OnOut21)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CIOTest message handlers

BOOL CIOTest::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	SetTimer(TESTTIMER,100,NULL);               //IO test timer starts

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
//***************Signal input**********************//
void CIOTest::CheckInput()
{
	int nID[]={IDC_IN0,IDC_IN1,IDC_IN2,IDC_IN3,IDC_IN4,IDC_IN5,IDC_IN6,IDC_IN7,IDC_IN8,IDC_IN9,
		      IDC_IN10,IDC_IN11,IDC_IN12,IDC_IN13,IDC_IN14,IDC_IN15,IDC_IN16,IDC_IN17,IDC_IN18,IDC_IN19,
			  IDC_IN20,IDC_IN21,IDC_IN22,IDC_IN23,IDC_IN24,IDC_IN25,IDC_IN26,IDC_IN27,IDC_IN28,IDC_IN29,
			  IDC_IN30,IDC_IN31,IDC_IN32,IDC_IN33,IDC_IN34,IDC_IN35,IDC_IN36,IDC_IN37,IDC_IN38,IDC_IN39,
			  IDC_IN40,IDC_IN41,IDC_IN42,IDC_IN43,IDC_IN44,IDC_IN45,IDC_IN46,IDC_IN47,IDC_IN48,IDC_IN49};


	CButton *btn;
	int value,i,n;

	for (i=0; i<7; i++)
	{             
		adt8840a_read_8bit(devnum,i*8,&value);
		for(n=0;n<8;n++)
		{
			if((i*8+n)<50)
			{
				btn=(CButton*)GetDlgItem(nID[i*8+n]);		
				btn->SetCheck((value & (1<<n))==0? 1:0);
			}else
				break;
		}
	}
}
//******************Signal output***********************//
void CIOTest::CheckOutput()
{
	int nID[]={IDC_OUT0,IDC_OUT1,IDC_OUT2,IDC_OUT3,IDC_OUT4,IDC_OUT5,IDC_OUT6,IDC_OUT7,IDC_OUT8,IDC_OUT9,
		IDC_OUT10,IDC_OUT11,IDC_OUT12,IDC_OUT13,IDC_OUT14,IDC_OUT15,IDC_OUT6,IDC_OUT17,IDC_OUT18,IDC_OUT19,
		IDC_OUT20,IDC_OUT21};

	CButton *btn;
	for (int i=0; i<22; i++)
	{
		btn=(CButton*)GetDlgItem( nID[i]);
		g_CtrlCard.Write_Output(i,btn->GetCheck());
	}

}
//*************Timer****************//
void CIOTest::OnTimer(UINT nIDEvent) 
{
	CheckInput();             //Detection of input signal

//	CheckOutput();            //Detection of output signal
	
	CDialog::OnTimer(nIDEvent);
}

//***************Output fully open*******************//
void CIOTest::OnOutAllopen() 
{
	int nID[]={IDC_OUT0,IDC_OUT1,IDC_OUT2,IDC_OUT3,IDC_OUT4,IDC_OUT5,IDC_OUT6,IDC_OUT7,
			  IDC_OUT8,IDC_OUT9,IDC_OUT10,IDC_OUT11,IDC_OUT12,IDC_OUT13,IDC_OUT14,IDC_OUT15,
			  IDC_OUT16,IDC_OUT17,IDC_OUT18,IDC_OUT19,IDC_OUT20,IDC_OUT21};

	CButton *btn;

	for (int i=0; i<22; i++)
	{

		btn=(CButton*)GetDlgItem( nID[i]);

		btn->SetCheck(1);
		
		g_CtrlCard.Write_Output(i,1);
	}
}
//****************Output fully closed***************//
void CIOTest::OnOutAllclose() 
{
	int nID[]={IDC_OUT0,IDC_OUT1,IDC_OUT2,IDC_OUT3,IDC_OUT4,IDC_OUT5,IDC_OUT6,IDC_OUT7,
			  IDC_OUT8,IDC_OUT9,IDC_OUT10,IDC_OUT11,IDC_OUT12,IDC_OUT13,IDC_OUT14,IDC_OUT15,
			  IDC_OUT16,IDC_OUT17,IDC_OUT18,IDC_OUT19,IDC_OUT20,IDC_OUT21};

	CButton *btn;

	for (int i=0; i<22; i++)
	{

		btn=(CButton*)GetDlgItem( nID[i]);
		btn->SetCheck(0);
		g_CtrlCard.Write_Output(i,0);
	}
}

//**********Out of IO test***************//
void CIOTest::OnDestroy() 
{
	CDialog::OnDestroy();
	
	OnOutAllclose();              //Output fully closed
	KillTimer(TESTTIMER);         //Close IO detection timer
	
}

void CIOTest::OnOut0() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT0);
	adt8840a_write_bit(devnum, 0, btn->GetCheck());
}

void CIOTest::OnOut1() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT1);
	adt8840a_write_bit(devnum, 1, btn->GetCheck());
}

void CIOTest::OnOut2() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT2);
	adt8840a_write_bit(devnum, 2, btn->GetCheck());
}

void CIOTest::OnOut3() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT3);
	adt8840a_write_bit(devnum, 3, btn->GetCheck());
}

void CIOTest::OnOut4() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT4);
	adt8840a_write_bit(devnum, 4, btn->GetCheck());
}

void CIOTest::OnOut5() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT5);
	adt8840a_write_bit(devnum, 5, btn->GetCheck());
}

void CIOTest::OnOut6() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT6);
	adt8840a_write_bit(devnum, 6, btn->GetCheck());
}

void CIOTest::OnOut7() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT7);
	adt8840a_write_bit(devnum, 7, btn->GetCheck());
}

void CIOTest::OnOut8() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT8);
	adt8840a_write_bit(devnum, 8, btn->GetCheck());
}

void CIOTest::OnOut9() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT9);
	adt8840a_write_bit(devnum, 9, btn->GetCheck());
}

void CIOTest::OnOut10() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT10);
	adt8840a_write_bit(devnum, 10, btn->GetCheck());
}

void CIOTest::OnOut11() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT11);
	adt8840a_write_bit(devnum, 11, btn->GetCheck());
}

void CIOTest::OnOut12() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT12);
	adt8840a_write_bit(devnum, 12, btn->GetCheck());
}

void CIOTest::OnOut13() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT13);
	adt8840a_write_bit(devnum, 13, btn->GetCheck());
}

void CIOTest::OnOut14() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT14);
	adt8840a_write_bit(devnum, 14, btn->GetCheck());
}

void CIOTest::OnOut15() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT15);
	adt8840a_write_bit(devnum, 15, btn->GetCheck()); 
}

void CIOTest::OnOut16() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT16);
	adt8840a_write_bit(devnum, 16, btn->GetCheck());
}

void CIOTest::OnOut17() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT17);
	adt8840a_write_bit(devnum, 17, btn->GetCheck());
}

void CIOTest::OnOut18() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT18);
	adt8840a_write_bit(devnum, 18, btn->GetCheck());
}

void CIOTest::OnOut19() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT19);
	adt8840a_write_bit(devnum, 19, btn->GetCheck());
}

void CIOTest::OnOut20() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT20);
	adt8840a_write_bit(devnum, 20, btn->GetCheck());
}

void CIOTest::OnOut21() 
{
	// TODO: Add your control notification handler code here
	CButton *btn;
	btn=(CButton*)GetDlgItem(IDC_OUT21);
	adt8840a_write_bit(devnum, 21, btn->GetCheck());
}
